<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
<#assign sid = sys.getName()/>
<#assign sname = sys.getLogicName()/>
<#assign hasWF=false>
<#if sys.getAllPSWorkflows()??>
    <#list sys.getAllPSWorkflows() as wf>
        <#if wf.getPSWFVersions()??>
            <#list wf.getPSWFVersions() as wfvs>
                <#assign hasWF=true>
            </#list>
        </#if>
    </#list>
</#if>
<#assign hasMsgTemplate=false>
<#if sys.getAllPSSysMsgTempls()??>
    <#list sys.getAllPSSysMsgTempls() as msgTempl>
        <#assign hasMsgTemplate=true>
        <#break>
    </#list>
</#if>
package ${pub.getPKGCodeName()}.util.job;

import ${pub.getPKGCodeName()}.util.client.IBZUAAFeignClient;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONArray;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;
import java.io.InputStream;
import java.util.*;

/**
 * 权限：向uaa同步当前系统菜单、权限资源任务类
 */
@Slf4j
@Component
@ConditionalOnProperty( name = "ibiz.enablePermissionValid", havingValue = "true")
public class PermissionSyncJob implements ApplicationRunner {

    @Autowired
    @Lazy
    private IBZUAAFeignClient client;

    @Value("${r'$'}{ibiz.systemid:${sid}}")
    private String systemId;
    
    @Value("${r'$'}{ibiz.systemname:${sname}}")
    private String systemName;

    <#if hasWF>
    @Autowired
    @Lazy
    private ${pub.getPKGCodeName()}.util.client.IBZWFFeignClient client2;
    </#if>

    <#if hasMsgTemplate>
    @Autowired
    @Lazy
    private ${pub.getPKGCodeName()}.util.client.IBZNotifyFeignClient notifyFeignClient;
    </#if>

    @Override
    public void run(ApplicationArguments args) {
        try {
            Thread.sleep(10000);
            InputStream permission= this.getClass().getResourceAsStream("/permission/systemResource.json"); //获取当前系统所有实体资源能力
            String permissionResult = IOUtils.toString(permission,"UTF-8");
            JSONObject system= new JSONObject();
            system.put("pssystemid",systemId);
            system.put("pssystemname",systemName);
            system.put("sysstructure",JSONObject.parseObject(permissionResult));
            system.put("md5check",DigestUtils.md5DigestAsHex(permissionResult.getBytes()));
            if(client.syncSysAuthority(system)){
                log.info("向[UAA]同步系统资源成功");
            }else{
                log.error("向[UAA]同步系统资源失败");
            }
        }
        catch (Exception ex) {
            log.error(String.format("向[UAA]同步系统资源失败，请检查[UAA]服务是否正常! [%s]",ex));
        }

        <#if hasWF>
        try{
            List<Map<String,Object>> bpmnfiles=new ArrayList();
            <#list sys.getAllPSWorkflows() as wf>
                <#if wf.getPSWFVersions()??>
                    <#list wf.getPSWFVersions() as wfvs>
            bpmnfiles.add(new HashMap<String,Object>(){{put("${wfvs.codeName}.bpmn",IOUtils.toString(this.getClass().getResourceAsStream("/workflow/${wfvs.codeName}.bpmn"),"UTF-8"));}});
                    </#list>
                </#if>
            </#list>
            if(client2.deployBpmnFile(bpmnfiles)){
                log.info("部署流程成功");
            }else{
                log.error("部署流程失败");
            }
        }catch(Exception ex){
            log.error(String.format("部署流程失败，请检查[WF]服务是否正常! [%s]",ex));
        }
        </#if>

        <#if hasMsgTemplate>
        try {
            InputStream msgTemplate= this.getClass().getResourceAsStream("/msgtempl/systemMsgTempl.json"); //获取当前系统所有实体资源能力
            String strMsgTemplate = IOUtils.toString(msgTemplate,"UTF-8");
            JSONObject template= new JSONObject();
            template.put("template",JSONArray.parseArray(strMsgTemplate));
            if(notifyFeignClient.createMsgTemplate(template)){
                log.info("推送消息模板成功");
            }else{
                log.error("推送消息模板失败");
            }
        } catch (Exception e) {
            log.error("推送消息模板失败");
        }
        </#if>
    }
}